#ifndef __DM_HARDWARE_H__
#define __DM_HARDWARE_H__

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"
#ifdef __cplusplus
extern "C" {
#endif

#define NONE                            0xffffffff

////////////////////////////////////////////////////////////////////////////////

typedef void (*TOFUNC)(UINT32 param);
typedef void (*TO_VOID_FUNC)(void);
typedef void (*TO_ISR_FUNC)(UINT8 idx);

//Function pointer to complete NVL updates
extern TO_VOID_FUNC pCompleteNvlUpdate;

#ifndef _HARDWARE_C_
extern TO_ISR_FUNC st_pUartISR[];
extern TO_ISR_FUNC st_pTimerISR[];
extern TO_ISR_FUNC st_pi2cISR[];
extern TO_ISR_FUNC st_pExternalInterruptISR[];
extern TO_ISR_FUNC st_pDmaISR[];
extern TO_ISR_FUNC st_pAdcISR;
#endif
INT8 AssignUartISR(UINT8 idx, TO_ISR_FUNC func) ;
INT8 AssignTimerISR(UINT8 idx, TO_ISR_FUNC func);
INT8 AssignI2cISR(UINT8 idx, TO_ISR_FUNC func);
INT8 AssignWIUExtIntISR(UINT8 idx, TO_ISR_FUNC func);
INT8 AssignDmaISR(UINT8 idx, TO_ISR_FUNC func);
INT8 AssignADCISR( TO_ISR_FUNC func);
void UART_DefaultIRQHandler(UINT8 uartNum);
////////////////////////////////////////////////////////////////////////////////
extern void HwForceTimerCompareOutput(UINT8 inst, UINT8 channel, UINT8 state);
extern UINT32 HwGetSystemClockHz(void);
extern void HwUseTmrOutWithChannel(UINT32 inst, UINT32 channel, UINT32 usec, TOFUNC pfCallback, UINT32 param, UINT32 output);
extern void HwUseTmrReLoadOutWithChannel(UINT32 inst, UINT32 channel, UINT32 usec, TOFUNC pfCallback, UINT32 param, UINT32 output);
extern void HwUseTmrAbortWithChannel(UINT32 inst, UINT32 channel);
extern void HwUseTmrCaptureInputWithChannel(UINT32 inst, UINT32 channel, TOFUNC pfCallback, UINT32 param, UINT32 edge);
extern UINT16 HwGetCaptureValue (UINT32 inst, UINT32 channel);


extern void HwDelayUsec(UINT32 inst, UINT32 usec, TOFUNC pfCallback, UINT32 param);
extern void HwDelayUsecAbort(UINT32 inst);
extern void HwDelayMsec(UINT32 ms);
extern UINT32 HwGetMsec(void);
extern void HwUsecTimerIsr(UINT8 param);
extern UINT16 HwGetCounterValue (UINT32 Inst);

extern void HwDelayUsecWithChannel(UINT32 inst, UINT32 channel, UINT32 usec, TOFUNC pfCallback, UINT32 param);
extern void HwDelayUsecAbortWithChannel(UINT32 inst, UINT32 channel);

extern INT16 HwExtInterInit(UINT32 inst, BOOL GPIO_Edge, TOFUNC pfCallback, UINT32 param);
extern INT32 HwExtInterEnable (UINT32 inst, BOOL GPIO_Edge);
extern void  HwExtInterIsr (UINT32 param);
extern INT32 HwExtInterDisable (UINT32 inst);

// uart stuff - move elsewhere?
extern void HwUartSetBaudRate(UINT32 inst, UINT32 bps, UINT32 stopBits);
extern void HwUartDisableInterrupts(UINT32 inst);
void HwUartConfig(UINT32 inst, UINT32 bps, UINT32 stopBits, UINT32 parity, UINT32 wlenght, UINT32 hwcontrol);
extern void HwUartSendBreak(UINT32 inst);
void HwUartClearBreak(UINT32 inst);
extern UINT32 HwGetCresnetSlaveUart(void);
//extern UINT32 HwGetCresnetMasterUart(UINT32 inst);
extern UINT32 HwGetConsoleUart(void);
extern UINT32 HwGetCresnetSlaveTimer(void);
//extern UINT32 HwGetCresnetMasterTimer(UINT32 inst);
extern void HwUartTx(UINT32 uartNum, UINT8 data);
void HwUartTxComplete(UINT32 uartNum, UINT8 enable);
extern void HwUartDisableReceiver(UINT32 uartNum);
extern void HwUartFlushReceiver(UINT32 uartNum);
extern void HwUartEnableReceiver(UINT32 uartNum);
extern void HwUartEnableTxInt(UINT32 uartNum, UINT8 enable);

void prvSetupHardware( void );
#ifndef DGE1
extern void portYIELD(void);
#endif
extern UINT32 UartIsr(UINT32 inst, UINT8 recStatus, BOOL rxReady, UINT8 newByte, BOOL txEmpty);
extern void ExternalIRQHandler(UINT8 inst);

// NVL Data Routines
UINT32 GetTSID(void);
void SaveTSID(UINT32 tsid);
void TriggerSystemSave(void);
void VerifyNVLData(void);
void UpdateSystemNVL(void);
void NVLCopyFromFlashToRam(void);
void NVLCopyFromFlashToRamCsumError(void);
void InitNVLSector(void);

//NVL Project specific block
UINT32 GetCardSpecificBlockStart( void );
UINT32 GetCardSpecificBlockMaxSize( void );
UINT32 GetCardSpecificBlockSize( void );
UINT8* GetCardSpecificBlock( void );
void VerifyCardSpecificBlock( void );
void RestoreCardSpecificDefaults( void );
void RestoreHdcpCardSpecificDefaults(void);
void RestoreEdidCardSpecificDefaults(void);
void RestoreAnalogVideoSetting( void );
void ResetCardSpecificValues( void );
void TriggerCardSpecificSave( void );

#define NVL_TIMER_MS 500

#define CNET_PLUG_PLAY_BROADCAST_PPN            0x5A5A5A5A

#ifdef STR91X_IAR
#define RAMFUNC __ramfunc

#else //STR91X_IAR
#define RAMFUNC

// for the Cortex processors, the flash size and block size can be different
// so the cards must have a table of their flash information
typedef struct
{
  UINT16 FlashSizeKb;    // flash size in kbytes
  UINT16 FlashBlockSize; // size of a block in bytes
  UINT32 FlashEnd;       // address of last byte in Flash
}FLASH_PARAMETERS;
extern FLASH_PARAMETERS FlashInfo;

#define FLASH_NVL_DATA_START (FlashInfo.FlashEnd - FlashInfo.FlashBlockSize + 1)

#endif //STR91X_IAR
#define CARD_SPECIFIC_MAX_SIZE    GetCardSpecificBlockMaxSize()
#define CARD_SPECIFIC_START       GetCardSpecificBlockStart()

// Flash configuration for STM32F2 chips
#define INVALID_FLASH_ADDR 0xFFFFFFFF // It'll never reach 4GB on a uc flash right?
typedef enum
{
  FLASH_SINGLE_SECTOR_NVL, 
  FLASH_DOUBLE_SECTOR_NVL_WO_PREBOOT_2K_BLOCK,
  FLASH_DOUBLE_SECTOR_NVL_WITH_PREBOOT_2K_BLOCK,
  FLASH_DOUBLE_SECTOR_EXT_NVL_WITH_PREBOOT_2K_BLOCK,
  STM32F2_MAX_FLASH_CONFIG
} STM32F2_FLASH_CONFIG;

typedef struct {
  UINT32 PreBootStartAddr;  // Preboot start address in the flash
  UINT32 PreBootSize;       // Preboot size
  UINT32 BtlStartAddr;      // Bootloader start address in the flash
  UINT32 BtlSize;           // Bootloader size
  UINT32 AppStartAddr;      // Application start address in the flash
  UINT32 NVLSector1;        // NVL sector 1 (address and define)
  UINT32 NVLSector2;        // NVL sector 2 (address and define)
  UINT16 NvlDataSize;       // For both system and card specific data but not combined
} STM32F2_FLASH_MAP;

// Flash config can change in the bootloader for DM devices
#ifndef BOOTLOADER
extern const STM32F2_FLASH_CONFIG g_FlashConfig;
#else
extern STM32F2_FLASH_CONFIG g_FlashConfig;
#endif

extern const STM32F2_FLASH_MAP g_FlashMap[STM32F2_MAX_FLASH_CONFIG];

void InitFlash(UINT16 FlashSize);
RAMFUNC INT8 FlashWriteBlock(UINT32 WriteAddr, UINT8 * pBuffer, UINT32 byteCnt);
RAMFUNC void FlashEraseBlock(UINT32 BlockAddr);
RAMFUNC UINT32 FlashSetBank(UINT32 BlockAddr);
RAMFUNC void FlashReset(UINT16 FlashSize);
RAMFUNC BOOL EraseBootLoader(void);
RAMFUNC void SaveMACAddrInOTPFlash(char *maca);
UINT8 IsMACAddrValid(UINT8 *maca);
void ReadMACAddrFromOTPFlash(char *maca);
void ReadProcessorProductID(UINT16 *ProductID);
void FlashEraseApplication(void);
UINT32 FlashGetEndAddr(void);

// For NVL
typedef struct {
    UINT32 nvlSectorSize; // Nvl sector size
    BOOL (*pfNvlRead)  (UINT32 sector, UINT32 offset, UINT8* pBuf, UINT32 cnt); // To read from flash
    BOOL (*pfNvlWrite) (UINT32 sector, UINT32 offset, UINT8* pBuf, UINT32 cnt); // To write to flash
    void (*pfNvlErase) (UINT32 sector); // To erase flash sector
} FLASH_FUNCTIONS;

// For external NVL
void ExtNvlSetFlashFunctions(const FLASH_FUNCTIONS* pFlashFuncs);
void ExtNvlGetCardData(UINT32* pNvlSector, UINT32* pOffset);

// For saving and retrieving device ids from the core NVL section 
extern void NvlSaveCnetId(UINT8 cnetId);
extern void NvlSaveMnetId(UINT8 meshnetId);
extern void NvlResetDeviceIds(void);
extern UINT8 NvlGetCnetId(void);
extern UINT8 NvlGetMnetId(void);
extern const UINT8 g_NvlDefaultCnetId;

void EnableNVLWrites(void);
void DisableNVLWrites(void);

// bit flags defined in UART_RSECR register
#define FRAME_ERROR     1
#define PARITY_ERROR    2
#define BREAK_FLAG      4
#define OVERRUN_ERROR   8

// UartISR function recStatus possible values
#define GOT_ERROR       1
#define GOT_BREAK       2
#define GOT_SYNC        3

////////////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
}
#endif

#endif  //__DM_HARDWARE_H__

